/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.planning.mokos.FakeSet;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.util.Tuple;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class LongPropertyFilter
extends Processor {
    private List<Operation> planneableOps = Lists.newArrayList();
    private Set<Operation> planneableOpsView = new FakeSet<Operation>(this.planneableOps);
    private long[] vals;
    private String propertyName;
    private Effectivity effectivity = Effectivity.GAR;
    private Mode mode = Mode.PASS_MIN;

    public void setProperty(@Nonnull String propertyName) {
        this.propertyName = Preconditions.checkNotNull(propertyName, "property name cannot be null");
    }

    public void setEffectivity(@Nonnull Effectivity effectivity) {
        this.effectivity = Preconditions.checkNotNull(effectivity, "effectivity cannot be null");
    }

    public void setMode(@Nonnull Mode mode) {
        this.mode = Preconditions.checkNotNull(mode, "mode cannot be null");
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        super.setScheduler(scheduler);
        Preconditions.checkNotNull(this.propertyName, "property cannot be null");
        ShopConfiguration conf = scheduler.getSuperplan().getShopConf();
        PropertyDefinition pd = conf.getPropertyDefinition(this.effectivity.getEffectivity(), this.propertyName);
        Preconditions.checkNotNull(pd, "Unknown property %s of %s.", (Object)this.propertyName, (Object)this.effectivity);
        Preconditions.checkState(pd.getType().equals((Object)PropertyDefinition.PropertyType.LONG), "Property %s of %s has type %s instead of long.", (Object)this.propertyName, (Object)this.effectivity, (Object)pd.getType());
        Set<Operation> ops = scheduler.getOperations();
        this.vals = new long[ops.size()];
        for (Operation op : ops) {
            long val;
            Long v = (Long)this.effectivity.getPropertized(op).getProperty(pd);
            long l = val = v != null ? v : Long.MAX_VALUE;
            if (this.mode.equals((Object)Mode.PASS_MAX)) {
                val = LongPropertyFilter.invertValue(val);
            }
            this.vals[op.id] = val;
        }
    }

    private static long invertValue(long v) {
        if (v == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        return -v;
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        long min2 = Long.MAX_VALUE;
        for (Operation op : ops) {
            long v = this.vals[op.id];
            if (v > min2) continue;
            if (v < min2) {
                min2 = v;
                this.planneableOps.clear();
            }
            this.planneableOps.add(op);
        }
        return Tuple.create(this.getDefaultSuccessor(), this.planneableOpsView);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Effectivity {
        GAR{

            @Override
            Propertized getPropertized(Operation op) {
                return op.getGar();
            }

            @Override
            Class<? extends Propertized> getEffectivity() {
                return GeneralizedActionRequest.class;
            }
        }
        ,
        GOR{

            @Override
            Propertized getPropertized(Operation op) {
                return ProductionTreeAlgorithms.getNearestGor(op.getGar());
            }

            @Override
            Class<? extends Propertized> getEffectivity() {
                return GeneralizedOrderRequest.class;
            }
        };


        abstract Propertized getPropertized(Operation var1);

        abstract Class<? extends Propertized> getEffectivity();
    }

    public static enum Mode {
        PASS_MIN,
        PASS_MAX;

    }
}

